;**********************************
pro mc_tiltread_f,jobide,plot=plot,nosave=nosave,$
restorefile=restorefile,yr0=yr0,tau0=tau0,print0=print0,$
testw_tab,alpha_tab,testlat_tab,testfii_tab,el77=el77,oplot=oplot,ss=ss,ms=ms,psym0=psym0,theory=theory,q_tab=q_tab,mu_tab=mu_tab,qalb=qalb,ims_tab=ims_tab,iss_tab=iss_tab,enhanced=enhanced,xr0=xr0,iss_theory=iss_theory

;**********************************

if(n_params() le 0) then begin
print,' mc_tiltread_f,jobide,plot=plot,nosave=nosave,restorefile=restorefile,yrmax0=yrmax0'
print,'reads both mcnew_tilt.exe and mcnew_tilt_pos.exe outputs'
return
endif


outfile=jobide+'.ttt'
savefile=jobide+'.tiltsave'

iprint=0
if(keyword_set(print0)) then iprint=print0



if(not keyword_set(restorefile)) then begin
close,1
openr,1,outfile
posfile=''

on_ioerror,skip_read

nphot=0l
maxscat=0l
nbox=0l
nboxvis=0l
idum=0l

readf,1,versio
readf,1,posfile
if(versio ge 2) then begin
readf,1,ipos1,ipos2
print,'posfile,ipos1,ipos2'
print,posfile,ipos1,ipos2
endif
readf,1,sunfii,sunlat,nphot
readf,1,method
readf,1,ppar1,ppar2,ppar3
readf,1,seed
readf,1,sredu,zredu
readf,1,sizemin
readf,1,s20,f20
readf,1,ntest

testfii_ori=fltarr(ntest)
testlat_ori=fltarr(ntest)
readf,1,testfii_ori
readf,1,testlat_ori
readf,1,model_sat
readf,1,iglobe
readf,1,abox,arel
readf,1,nlat_sat,nfii_sat
readf,1,alpha_choice,lat_choice
readf,1,nlatsun
blatsun=fltarr(nlatsun)
readf,1,blatsun
tiltfile=''
readf,1,tiltfile



sunlat_tab=fltarr(nlatsun)
sunfii_tab=fltarr(nlatsun)
testlat_tab=fltarr(nlatsun,ntest)
testfii_tab=fltarr(nlatsun,ntest)
alpha_tab=fltarr(nlatsun,ntest)
testw_tab=fltarr(nlatsun,ntest)
testn_tab=fltarr(nlatsun,ntest)
testd_tab=fltarr(nlatsun,ntest)
testm_tab=fltarr(nlatsun,ntest,10)
tau_n_tab=fltarr(nlatsun)
tau_path_tab=fltarr(nlatsun)
fdirect_tab=fltarr(nlatsun)


mu_tab=testlat_tab
q_tab=mu_tab
ims_tab=q_tab
iss_tab=q_tab


cpucum=0.
if(iprint ge 0) then begin
print,'--------------------------------------------'
print,'tiltfile=',tiltfile
print,'posfile=',posfile
print,'--------------------------------------------'
endif

for ilatsun=0,nlatsun-1 do begin

readf,1,d1,d2
sunlat_tab(ilatsun)=d1
sunfii_tab(ilatsun)=d2
sunlat=d1
if(iprint ge 1) then print,'sunlat=',sunlat

for itest=0,ntest-1 do begin
readf,1,d1,d2,d3
testlat_tab(ilatsun,itest)=d1
testfii_tab(ilatsun,itest)=d2
alpha_tab(ilatsun,itest)=d3
endfor
testlat=testlat_tab(ilatsun,*)

testw=testfii_ori
testn=testfii_ori
testd=testfii_ori
testm=fltarr(ntest,10)
readf,1,testw
readf,1,testn
readf,1,testd
readf,1,testm

readf,1,iscat_mean,npot_mean,nbox_mean
readf,1,npartori,npart,mx,my
readf,1,tau
readf,1,fdirect,tau_path,tau_n
readf,1,cpu,cpu_comp

;different for each bobs
iperf=abs(sin(sunlat/!radeg)/nphot/sin(testlat/!radeg))  

testw_tab(ilatsun,*)=testw*iperf
testn_tab(ilatsun,*)=testn
testd_tab(ilatsun,*)=testd*iperf
for i=0,9 do begin
testm_tab(ilatsun,*,i)=testm(*,i)*iperf
endfor



ff='(f7.3)'
if(iprint ge 2) then begin
if(ilatsun eq 1) then print,'tau_dyn=',tau
print,'tau_path,tau_n, d_tau_n '+string(tau_path,ff)+string(tau_n,ff)+string(1./sqrt(nphot*fdirect)/sin(testlat/!radeg))
print,'taudyn, tauphot/taudyn',string(tau,ff)+string(tau_n/tau,ff)
print,'nphot,cpu=',nphot,cpu
print,'fdirect',fdirect
endif

cpucum=cpucum+cpu
tau_n_tab(ilatsun)=tau_n
tau_path_tab(ilatsun)=tau_path
fdirect_tab(ilatsun)=fdirect



endfor

;error estimate
dtau_n_tab=1./sqrt(fdirect_tab*nphot)

if(keyword_set(qalb)) then begin
for itest=0,ntest-1 do begin
testm=reform(testm_tab(*,itest,*))
albedo,testm,testa,qalb
itot=testa
albedo,testm,testa,qalb,pr=0.00001
ims=testa
q_tab(*,itest)=ims/itot
ims_tab(*,itest)=ims
iss_tab(*,itest)=itot-ims

endfor
mu_tab=sin(testlat_tab/!radeg)
endif



if(iprint ge 0) then print,'method,nphot,cpu',method,nphot,cpucum

if(not keyword_set(nosave)) then begin
if(iprint ge 0) then print,'saved to ',savefile
save,file=savefile,jobide,tiltfile,testw_tab,testn_tab,testd_tab,testm_tab,$
sunlat_tab,sunfii_tab,testlat_tab,testfii_tab,alpha_tab,tau_n_tab,cpucum,method,model_sat,iglobe,npartori,mx,my,tau,alpha_choice,lat_choice,nlatsun,abox,arel,nphot,ppar1,ppar2,ppar3,tau_path_tab,fdirect_tab,dtau_n_tab
endif


skip_read:
close,1

endif;no restore

restore,savefile

nalpha=n_elements(testlat_tab(0,*))
;print,nalpha

;theoretical ss-flux  tau=theory
if(keyword_set(theory)) then begin
ss_theory=fltarr(nlatsun,nalpha)

for i=0,nalpha-1 do begin
alpha=alpha_tab(0,i)
print,alpha
alpha=alpha/!radeg
phasef=0.
if(method eq 2) then phasef=1./4./!pi

if(method eq 1 or method eq 11 or method eq 12) then begin
    s=!pi-alpha
    cosa=cos(s)
    sina=sin(s)
    vak=1./!pi^2/3.*2.
    phasef=vak*(sina-s*cosa)
endif

if(method eq 3 or method eq 4) then begin
    g=ppar1
    cosa=cos(!pi-alpha)
    phasef=1./4./!pi*(1.-g^2)/(1.-2*g*cosa+g^2)^(1.5)
endif

if(method eq 13 or method eq 14) then begin
    g1=ppar1
    g2=ppar2
    bb=ppar3
    cosa=cos(!pi-alpha)
    phasef1=1./4./!pi*(1.-g1^2)/(1.-2*g1*cosa+g1^2)^(1.5)
    phasef2=1./4./!pi*(1.-g2^2)/(1.-2*g2*cosa+g2^2)^(1.5)
    phasef=bb*phasef1+(1.-bb)*phasef2
endif

if(method eq 7 or method eq 8) then begin
    s=!pi-alpha
    phasef=0.153*s^3.092/4./!pi
endif
mu=abs(sin(testlat_tab/!radeg))
mu0=abs(sin(sunlat_tab/!radeg))
tau_path=abs(theory)*(1./mu+1./mu0)
ss_theory(*,i)=mu0*phasef*(1.-exp(-tau_path))/4./(mu0+mu)*4*!pi
endfor

if(theory lt 0) then print,ss_theory
iss_theory=ss_theory
endif


st_ss=' MS+SS  ALB=1'

psym=-4
if(keyword_set(psym0)) then psym=psym0

if(keyword_set(ss)) then st_ss=' SS ALB=1' 
if(keyword_set(ms)) then st_ss=' MS ALB=1' 
if(keyword_set(plot)) then begin


test_plot=testw_tab

if(keyword_set(ss)) then test_plot=testm_tab(*,*,0)
if(keyword_set(ms)) then test_plot=testw_tab-testm_tab(*,*,0)

xr=[0,0]
if(keyword_set(xr0)) then xr=xr0
yr=[0,0]
if(keyword_set(yr0)) then yr=yr0

if(plot eq 1) then begin
nwin
plot,testlat_tab(*,0),test_plot(*,0),psym=psym,xtitle="B=B'",ytitle='I/F'+st_ss,title=jobide,xr=xr,yr=yr
endif
for i=0,nalpha-1 do begin
oplot,testlat_tab(*,i),test_plot(*,i),psym=psym,col=i+1
xyouts,testlat_tab(nlatsun-1,i),test_plot(nlatsun-1,i),string(alpha_tab(0,i),'(f6.2)')
if(keyword_set(theory)) then begin
oplot,testlat_tab(*,i),ss_theory(*,i),psym=0,col=i+1,lines=0,thick=3
endif
endfor
endif

if(keyword_set(oplot)) then begin
nalpha=n_elements(testlat_tab(0,*))
;print,nalpha
test_plot=testw_tab
if(keyword_set(ss)) then test_plot=testm_tab(*,*,0)
if(keyword_set(ms)) then test_plot=testw_tab-testm_tab(*,*,0)
for i=0,nalpha-1 do begin
oplot,testlat_tab(*,i),test_plot(*,i),psym=psym,col=i+1+oplot

if(keyword_set(theory)) then begin
oplot,testlat_tab(*,i),ss_theory(*,i),psym=0,col=i+1+oplot,thick=3,lines=0
endif

xyouts,testlat_tab(nlatsun-1,i),test_plot(nlatsun-1,i),string(alpha_tab(0,i),'(f6.2)')
endfor

if(keyword_set(enhanced)) then begin
nwin
plot,testlat_tab(0,i),testm_tab(*,0,0)/ss_theory(*,0),xtitle='elevation B',ytitle='ss/ss_theory'
endif

endif ;PLOT


if(keyword_set(el77)) then begin
testm=reform(testm_tab(*,0,*))
albedo,testm,testa,el77

p_el=(testa(1,0)-testa(0,0))/testa(1,0)

st_el=string(ppar1,ff)+string(ppar2,ff)+string(ppar3,ff)
st_pel=string(p_el,ff)
st_mu=string(testlat_tab(0,0),ff)+string(testlat_tab(1,0),ff)
st_alpha=string(alpha_tab(0),ff)
st_alb=string(el77,ff)

print,'----------------------------------'
print,'el77 comparison: g1,g2,b'+st_el
print,'slope between mu=',st_mu,' for alpha='+st_alpha
print,'for ALB='+st_alb,' equal P_el= '+st_pel
print,'I/F/0.62=',testa/0.62
print,'method: ',method
endif


end
















