;*****************************************
; mc_asyobs_read.pro 
;*****************************************
;reads correctly mcnewd_asyobs.exe output

pro mc_asyobs_read,allfile,plot=plot,posmax=posmax,$
error=error,noprint=noprint,bsun_use=bsun_use,print=print

if(n_params() le 0) then begin
    print,'pro mc_asyobs_read,allfile'
    print,'reads output of mcnewd_asyobs.exe'
    print,'and saves results into idl-savefile'
    print,'/plot   -> plot results'
    print,'/error  -> error estimates (even vs. odd pos-files)'
    print,' posmax -> use only first posmax pos-files'
    print,'/noprint-> reduced output to terminal'
    print,' bsun_use -> use this value for bsun (just for RPX with bsun=0)'
    print,' example:'
    print," mc_asyobs_read,'asytest1.all',/plot"
    return
endif


ar=1./!radeg
ra=1./ar

amp_tab100=fltarr(3)
amp_tab50=fltarr(3)
min_tab100=fltarr(3)
min_tab50=fltarr(3)

;*************************************************
; error estimates
;  first calculate results using all pos-files (icase=1)
;  next using even pos-files (icase=2)
;  last using odd pos-files (icase=3)
; errors from difference between icase=2 and icase=3

casemax=1
if(keyword_set(error)) then casemax=3

iprint=1
if(keyword_set(noprint)) then iprint=0

if(keyword_set(print)) then iprint=print


;****************************************************************
for icase=1,casemax do begin
if (casemax gt 1 and iprint eq 1) then print,'icase=',icase,'  ',allfile
close,1
openr,1,allfile

readf,1,versio
runtype='asymmetry-run:'

print,'---------------------------------------------------------------------'
if(icase eq 1) then print,runtype,'  versio=',byte(versio)
runide=''
readf,1,runide
runide=strtrim(runide)
allfile=strtrim(allfile)
extract_title,allfile,allfile2,/nop
if(icase eq 1) then begin
print,'runide=  ',runide
print,'allfile= ',allfile2
print,'---------------------------------------------------------------------'
endif
readf,1,pos1,pos2

readf,1,bsun,bobs,dlobs_ori
if(keyword_set(bsun_use)) then bsun=bsun_use
lonobs=0.
lonsun=dlobs_ori

readf,1,azi1,azi2,nazi
mx=0
my=0
if(versio eq 0) then readf,1,nphot
if(versio gt 0) then readf,1,nphot,mx,my

azitable=fltarr(nazi)
obstable=azitable
suntable=azitable
readf,1,azitable
readf,1,obstable
readf,1,suntable

npos=pos2-pos1+1
postable=lonarr(npos)

method=0l
sredu=1.
zredu=1.
sizemin=0.
s20=0.
f20=0.
ppar1=-999.
ppar2=-999.
ppar3=-999.
if(versio ge 2) then begin
readf,1,method
readf,1,sredu,zredu
readf,1,sizemin,s20,f20
if(versio ge 3) then readf,1,ppar1,ppar2,ppar3

smethod=' '
if(method eq 1)  then smethod='LAMBERT-ELEMENT'
if(method eq 11) then smethod='LAMBERT-SPHERE-CENTER'
if(method eq 12) then smethod='LAMBERT-SPHERE-POINT'
if(method eq 3)  then smethod='HG-SPHERE-CENTER  '+string(ppar1,'(f7.4)')
if(method eq 4)  then smethod='HG-SPHERE-POINT  '+string(ppar1,'(f7.4)')
if(method eq 13) then smethod='HG2-SPHERE-CENTER  '+string(ppar1,'(f7.4)')+string(ppar2,'(f7.4)')+string(ppar3,'(f7.4)')
if(method eq 14) then smethod='HG2-SPHERE-POINT  '+string(ppar1,'(f7.4)')+string(ppar2,'(f7.4)')+string(ppar3,'(f7.4)')
if(method eq 5)  then smethod='EULER-SPHERE-CENTER  '+string(ppar1,'(f7.4)')
if(method eq 6)  then smethod='EULER-SPHERE-POINT  '+string(ppar1,'(f7.4)')
if(method eq 7)  then smethod='CALLISTO-SPHERE-CENTER  '
if(method eq 8)  then smethod='CALLISTO-SPHERE-POINT  '
if(method eq 9)  then smethod='POWER-SPHERE-CENTER  '+string(ppar1,'(f7.4)')
if(method eq 10) then smethod='POWER-SPHERE-POINT  '+string(ppar1,'(f7.4)')
if(icase eq 1) then print,'method= ',method,'  ',smethod
endif

;versio4
iglobe=0
abox=0.
rsaturn=1.
nlat_sat=-999
nfii_sat=-999
model_sat=0
smodel=' '
sglobe='SUN'

if(versio ge 4) then begin
      readf,1,   iglobe
      readf,1,    abox,rsaturn
      readf,1,   nlat_sat,nfii_sat
      readf,1,   model_sat
      if(icase eq 1 and iprint ge 1) then begin
      print,'iglobe   = ',iglobe
      print,'distance = ',abox,abox/rsaturn
      print,'nfii,nlat= ',nlat_sat,nfii_sat
      print,'model_sat= ',model_sat
      endif
      if(iglobe eq 0) then sglobe='SUN'
      if(iglobe eq 1) then sglobe='SATURN, DIST= '+string(abox,'(f7.1)')
      if(iglobe eq 2) then sglobe='SATURN-SOUTH,  DIST= '+string(abox,'(f7.1)')
      if(iglobe eq 3) then sglobe='SATURN-NORTH,  DIST= '+string(abox,'(f7.1)')

      if(model_sat eq 1) then smodel='LAMBERT-PLANET'
      if(model_sat eq 2) then smodel='RED-PLANET'
      if(model_sat eq 3) then smodel='BLUE-PLANET'
      if(model_sat eq 4) then smodel='RED/BLUE-PLANET'
      if(model_sat eq 5) then smodel='ZONES RED 25/BLUE 75-PLANET'
      if(model_sat eq 6) then smodel='BELTS RED 25/BLUE 75-PLANET'
      if(model_sat eq 11) then smodel='BELTS RED'
      if(model_sat eq 12) then smodel='BELTS BLUE'
      if(model_sat eq 13) then smodel='ZONES RED'
      if(model_sat eq 14) then smodel='ZONES BLUE'
endif
d_per_a=0.
if(versio ge 5) then begin
readf,1,d_per_a
if(icase eq 1 and iprint ge 1) then print,'distance to voyager (0-infinity)',d_per_a
endif



;these tables include all data
tablew=fltarr(nazi,npos)
tabled=tablew
tablen=tablew
tablem=fltarr(nazi,npos,10)
table_fdirect=tablew
apu1=fltarr(nazi)
apu2=fltarr(nazi,10)


if(keyword_set(posmax)) then pos2=pos1+posmax-1
npos=pos2-pos1+1
if(icase eq 1 and iprint ge 1) then begin
print,'POS1,POS2      ',pos1,pos2,f='(a15,2i8)'
print,'B_sun, LON_sun ',bsun,lonsun,f='(a15,2f8.3)'
print,'B_obs, LON_obs ',bobs,lonobs,f='(a15,2f8.3)'
print,'NPHOT,Mx,My    ',nphot,mx,my,f='(a15,3i8)'
print,'AZIMUTHS:       ',min(azitable),max(azitable),n_elements(azitable),$
f='(a15,2f8.3,i8)'
endif

if(versio eq 0) then readf,1,versio
pos=0l

for i=0,npos-1 do begin
    readf,1,pos
    postable(i)=pos
    posfile=''

testfii_tod=-azitable
testlat_tod=azitable*0.+bobs

;********************************************
;Saturn-shine related input was added in here

flux_sat=0.
nphot_sat=0.
flux_sat_azi=0.
nphot_sat_azi=0.

if(versio ge 4) then begin
    nphot_sat_azi=lonarr(nazi)
    flux_sat_azi=fltarr(nazi)
    for j=0,nazi-1 do begin

        if(versio ge 5) then begin
            readf,1,apuli1,apuli2
            testfii_tod(j)=apuli1
            testlat_tod(j)=apuli2
            dlobsj=suntable(j)-testfii_tod(j)
            bobsj=testlat_tod(j)
            
            cos_alpha=cos(dlobsj*ar)*cos(bsun*ar)*cos(bobsj*ar)+$
              sin(ar*bobsj)*sin(bsun*ar)
            alphaj=acos(cos_alpha)*ra

            if(icase eq 1 and i eq 0 and iprint ge 2) then $
              print,'obs:',j,azitable(j),apuli1,apuli2,alphaj
        endif


        readf,1,flux_sat,nphot_sat
;       if(iglobe ne 0) then print,'nphot_sat,flux_sat',nphot_sat,flux_sat
        flux_sat_azi(j)=flux_sat
        nphot_sat_azi(J)=nphot_sat
    endfor
endif
;end Saturn-shine related input 
;********************************************

    readf,1,apu1
    tablew(*,i)=apu1
    readf,1,apu1
    tabled(*,i)=apu1
    readf,1,apu1
    tablen(*,i)=apu1

    readf,1,apu2
    for ii=0,nazi-1 do begin
        for jj=0,9 do begin
            tablem(ii,i,jj)=apu2(ii,jj)
        endfor
    endfor
    if(versio ge 2) then begin
         readf,1,apu1
         table_fdirect(*,i)=apu1
    endif

;--------------------
; Saturn-illumination: I/F weighting
; pi*F*sin(bsun)/NPHOT must then be replaced by
; FLUX_SAT_AZI/NPHOT_SAT_AZI
; make it here to tablew,tabled,tablem 

if(versio ge 4) then begin
    if(iglobe ge 1) then begin
        for j=0,nazi-1 do begin
            if(nphot_sat_azi(j) gt 0) then begin
                scafac=flux_sat_azi(j)/nphot_sat_azi(j) $
                  *nphot/!pi/abs(sin(bsun/!radeg))
;print,j,scafac
                tablew(j,i)=tablew(j,i)*scafac
                tabled(j,i)=tabled(j,i)*scafac
                tablem(j,i,*)=tablem(j,i,*)*scafac
            endif
        endfor
    endif
endif



endfor

npart=0l
npartori=0l
cpu=0.
cpu_comp=0.
npot_mean=0.
nbox_mean=0.
nscat_mean=0.
if(versio eq 0) then goto,skippi
readf,1,cpu
cpu_comp=cpu/nphot*1000./npos/nazi

readf,1,npart,npartori,npot_mean,nbox_mean,nscat_mean
readf,1,tau_dyn
if(icase eq 1 and iprint ge 1) then begin
print,'CPU=           ',cpu,cpu_comp,f='(a15,2f12.3)'
print,'PART,DUBL,NPOT ',npartori,npart,npot_mean,f='(a15,3i8)'
print,'NBOX,NSCAT     ',nbox_mean,nscat_mean,f='(a15,2f8.3)'
print,'TAU_DYN=',tau_dyn
endif

skippi:
close,1

if(keyword_set(posmax)) then begin
print,'posmax=',posmax
npos=posmax
for i=0,npos-1 do begin
print,i,mean(tablew(*,i))
endfor
endif

;*************************************************************
;average values over posfiles

meanw=fltarr(nazi)
meand=meanw
meann=meanw
meanm=fltarr(nazi,10)

if(icase eq 1) then begin
ifirst=0
step=1
endif

if(icase eq 2) then begin
ifirst=0
step=2
step=1
endif

if(icase eq 3) then begin
ifirst=1
step=2
endif

pos_use=[-1]
lask=0
for i=ifirst,npos-1,step do begin
    meanw=meanw+tablew(*,i)
    meand=meand+tabled(*,i)
    meann=meann+tablen(*,i)
lask=lask+1
    if(icase gt 1) then pos_use=[pos_use,i]
    for jj=0,9 do begin
        meanm(*,jj)=meanm(*,jj)+tablem(*,i,jj)
    endfor
endfor
meanw=meanw/lask
meand=meand/lask
meann=meann/lask
meanm=meanm/lask
;************************************************************

iperf=abs(sin(bsun/!radeg)/nphot/sin(bobs/!radeg))
amp=(max(meanw)-min(meanw))/min(meanw)
ifmax=iperf*max(meanw)
ifmin=iperf*min(meanw)

if(icase gt 1) then begin
 print,'icase=',icase
print,pos_use(1:*)
endif
if (iprint eq 1) then print,'IFMIN,IFMAX,AMP',ifmin,ifmax,amp,'  (alb=1.0)',f='(a15,3f8.3,a12)'

meanw50=meanw*0.
alb=0.5
for i=0,8 do begin
meanw50=meanw50+alb^(i+1.)*meanm(*,i)
endfor
ifmin50=min(meanw50)*iperf
ifmax50=max(meanw50)*iperf
amp50=(ifmax50-ifmin50)/ifmin50

if (iprint eq 1) then print,'IFMIN,IFMAX,AMP',ifmin50,ifmax50,amp50,'  (alb=0.5)',f='(a15,3f8.3,a12)'


;****************************************
if(icase eq 1) then begin

    ;tau,ss
    
    mu0=cos((90-bsun)/!radeg)
    mu =cos((90-bobs)/!radeg)
    fdirect_mean=azitable*0.
    for j=0,npos-1 do begin
        fdirect_mean=fdirect_mean+table_fdirect(*,j)
    endfor
    fdirect_mean=fdirect_mean/npos
    tau_n=-alog(fdirect_mean)*mu0
    taumean=-alog(mean(fdirect_mean))*mu0
    dtau_n=1./sqrt(fdirect_mean*nphot)*mu0

    if (iprint ge 2) then print,'dlobs ORI: ',dlobs_ori
    dlobs=suntable-testfii_tod
    if (iprint ge 2) then print,'dlobs MODI:',dlobs

    cos_alpha=cos(dlobs*ar)*cos(bsun*ar)*cos(bobs*ar)+sin(ar*bobs)*sin(bsun*ar)
    alpha=acos(cos_alpha)

    phasef=1.
    if (iprint ge 2) then begin
        print,'mu0,mu',mu0,mu
        print,'cosa',cos_alpha
        print,'alpha',alpha/ar
        print,'tau_n',taumean
    endif

if(method eq 1 or method eq 11 or method eq 12) then begin
alfa=!pi-acos(cos_alpha)
cosa=cos(alfa)
sina=sin(alfa)
vak=1./!pi^2/3.*2.
phasef=vak*(sina-alfa*cosa)
endif

if(method eq 3 or method eq 4) then begin
xx=cos(!pi-acos(cos_alpha))
phasef=1./4./!pi*(1.-g^2)/(1.-2*g*xx+g^2)^(1.5)
endif

if_ss=0.25*(mu0)/(mu0+mu)*(1.-exp(-taumean*(mu+mu0)/mu/mu0))*phasef*4.*!pi

if (iprint eq 1) then begin
print,'phasef,if_ss',phasef,if_ss
print,'calculated  ',iperf*mean(meanm(*,0))
endif

save,file=allfile+'.tausave',allfile,azitable,tau_n,meanw,meanw50,bsun,mu0,method
print,'saved to: ',allfile+'.tausave'


dlobs=suntable-testfii_tod
ar=1./!radeg
cos_alpha=cos(dlobs*ar)*cos(bsun*ar)*cos(testlat_tod*ar)+sin(ar*testlat_tod)*sin(bsun*ar)
alpha=acos(cos_alpha)

comment='variables explained in file MC_ASYOBS_READ.SAVEINFO'

save,file=allfile+'.save',runide,allfile,postable,azitable,$
bsun,bobs,lonsun,lonobs,nphot,mx,my,npartori,npart,cpu,cpu_comp,$
npot_mean,nbox_mean,nscat_mean,$
tablew,tabled,tablen,tablem,$
meanw,meand,meann,meanm,iperf,ifmax,ifmin,ifmax50,ifmin50,amp50,$
amp,comment,pos1,pos2,npos,nazi,meanw50,table_fdirect,method,$
ppar1,ppar2,ppar3,smethod,smodel,sglobe,flux_sat_azi,nphot_sat_azi,$
iglobe,abox,rsaturn,nlat_sat,nfii_sat,$
obstable,suntable,testfii_tod,testlat_tod,d_per_a,alpha,taumean,tau_n,tau_dyn,dtau_n

print,'--------------------------------------'
print,'saved to: ',allfile+'.save: contains alpha,tau_n'
print,comment
print,'--------------------------------------'

if(keyword_set(plot)) then mc_asy_plot_new,allfile+'.save'
endif

;*******************************************************
;azscan
theta=azitable-270.0
l=where(theta ge (-60.) and theta le 60.,nl)

if(nl gt 3) then begin

theta_min=round(theta[l[0]])
theta_max=round(theta[l[nl-1]])
nth=theta_max-theta_min+1
nbin=500
thetas=theta_min + findgen(nth*nbin+1)/nbin
nmid=(where(min(abs(thetas)) eq abs(thetas)))[0]
ncoeff=6

; albedo = 0.5 case
fourier_azscan,theta,iperf*meanw50,ncoeff,modelw50,coeffs
ym50=fourier_calc(thetas,coeffs)
l=(where(ym50 eq min(ym50)))[0]
theta_min_val=thetas[l]
min50=theta_min_val

; do same for albedo=1.0 case
fourier_azscan,theta,iperf*meanw,ncoeff,modelw,coeffs
ym=fourier_calc(thetas,coeffs)
l100=(where(ym eq min(ym)))[0]
theta_min_val100=thetas[l100]
min100=theta_min_val100

if(iprint ge 1) then begin
print,'fourier_azscan:'
print,'within 60 degrees from ansa'
print,'ALB=1.0  ifmax,ifmin,min',max(ym),min(ym),theta_min_val100
print,'ALB=0.5  ifmax,ifmin,min',max(ym50),min(ym50),theta_min_val
endif

amp_tab100(icase-1)=amp
amp_tab50(icase-1)=amp50
min_tab100(icase-1)=theta_min_val100
min_tab50(icase-1)=theta_min_val

endif ; nl


endfor;icase

if(casemax gt 1) then begin
print,'++++++++++++++++++++++++++++++++++++++++'
print,' '
print,'runide=  ',runide
print,'allfile= ',allfile2
print,'++++++++++++++++++++++++++++++++++++++++'
print,'AMPLITUDE, A=1.0:',amp_tab100(0),'  +/-',0.5*abs(amp_tab100(1)-amp_tab100(2))
print,'AMPLITUDE, A=0.5:',amp_tab50(0),'  +/-',0.5*abs(amp_tab50(1)-amp_tab50(2))
print,'MINIMUM, A=1.0:',-min_tab100(0),'  +/-',0.5*abs(min_tab100(1)-min_tab100(2))
print,'MINIMUM, A=0.5:',-min_tab50(0),'  +/-',0.5*abs(min_tab50(1)-min_tab50(2))
print,'++++++++++++++++++++++++++++++++++++++++'


a100=amp_tab100(0)
da100=abs(amp_tab100(1)-amp_tab100(2))
min100=-min_tab100(0)
dmin100=abs(min_tab100(1)-min_tab100(2))

a50=amp_tab50(0)
da50=abs(amp_tab50(1)-amp_tab50(2))
min50=-min_tab50(0)
dmin50=abs(min_tab50(1)-min_tab50(2))


save,file=allfile+'.ampsave',runide,allfile,postable,azitable,$
bsun,bobs,lonsun,lonobs,nphot,mx,my,npartori,a100,da100,min100,dmin100,$
a50,da50,min50,dmin50,method

print,'--------------------------------------'
print,'saved to: ',allfile+'.ampsave'
print,'--------------------------------------'

endif


print,'--------------'
print,runide
print,smethod
print,sglobe
if(iglobe gt 0) then print,smodel
print,'---------------------------------------------------------------------'
endi:
close,1
return
end












