;**************************************
pro mc_asy_plot_new,allsave, NOPLOT=noplot,bobs,bsun,$
	beff,alpha,lonsun,theta_min_val,width,theta_min_flux,flux_ansa,$
	frac_depth1,frac_depth2,yrange0=yrange0,comment0=comment0,amp100=amp100,amp50=amp50,min100=min100,min50=min50,wait=wait

smet='LAMBERT'
restore,allsave

if(defined(method) ge 0) then smet=string(method)
if(defined(smethod) ge 0) then smet=smethod
print,smet,method

amp100=amp

if keyword_set(NOPLOT) then PLOT=0 else PLOT=1
if PLOT then nwin
;!p.multi=[0,1,2]

posi1=[0.1,0.6, 0.9,0.95]
posi2=[0.1,0.1, 0.51,0.478]
posi3=[0.6,0.1, 0.95,0.478]
posi4=[0.6,0.6, 0.95,0.9]

if PLOT then plot,lindgen(1),xr=[0,1],yr=[0,1],/nodata,xs=15,ys=15,pos=posi1

!p.charsize=1.0
if(!d.name eq 'PS') then !p.charsize=0.75 
yl=1.05
xl=-0.05
dyl=-0.07
ff='(f9.2)'
ff3='(f7.3)'
ii='(i7)'
ii3='(i3)'
comment=''
if(keyword_set(comment0)) then comment=comment0
if PLOT then begin
xyouts,xl,yl,'---------------------------------' & yl=yl+dyl
xyouts,xl,yl,comment & yl=yl+dyl
xyouts,xl,yl,'ALLFILE: '+allfile+'   '+!stime & yl=yl+dyl
xyouts,xl,yl,'RUNIDE : '+runide+'   '+'POSDAT:'+string(pos1,f=ii3)+' -'+$
	string(pos2,f=ii3) & yl=yl+dyl

xyouts,xl,yl,'NPART, NPHOT, M   '+string(npartori,f=ii)+string(nphot,f=ii)$
	+string(mx,f=ii) & yl=yl+dyl
xyouts,xl,yl,'CPU, CPU_COMP   '+string(cpu,f=ff)+string(cpu_comp,f=ff3) 
yl=yl+dyl
xyouts,xl,yl,'---------------------------------' & yl=yl+dyl

xyouts,xl,yl,'METHOD = '+smet & yl=yl+dyl

if(defined(sglobe) ge 0) then xyouts,xl,yl,sglobe & yl=yl+dyl

if(defined(smodel) ge 0) then xyouts,xl,yl,smodel & yl=yl+dyl

xyouts,xl,yl,/data,'BSUN,LONSUN     ='+string(bsun,f=ff)+string(lonsun,f=ff) & yl=yl+dyl
xyouts,xl,yl,/data,'BOBS,LONOBS     ='+string(bobs,f=ff)+string(lonobs,f=ff) & yl=yl+dyl
endif

ar=atan(1.d0)*4.d0/180.d0
ra=1./ar

;print,bobs,bsun
apu1=cos(bobs*ar)*cos(bsun*ar)
apu2=sin(bobs*ar)*sin(bsun*ar)
cosa=apu2+apu1*cos(lonsun*ar)
alpha=acos(cosa<1)*ra
beff=asin(2.*sin(bobs*ar)*sin(bsun*ar)/(sin(bobs*ar)+sin(bsun*ar)))*ra
;print,beff

if PLOT then begin
xyouts,xl,yl,/data,'B_EFF, ALPHA     ='+string(beff,f=ff)+string(alpha,f=ff) 
yl=yl+dyl*1.2


xyouts,xl,yl,/data,'IFMAX,IFMIN,AMP='  & yl=yl+dyl
xyouts,xl,yl,/data,'  ALB=1.0 '+string(ifmax,f=ff3)+string(ifmin,f=ff3)+$
	string(amp,f=ff3) & yl=yl+dyl
endif


meanw50=meanw*0.
alb=0.5
for i=0,8 do begin
meanw50=meanw50+alb^(i+1.)*meanm(*,i)
endfor


ifmin50=min(meanw50)*iperf
ifmax50=max(meanw50)*iperf
amp50=(ifmax50-ifmin50)/ifmin50

if PLOT then begin
xyouts,xl,yl,/data,'  ALB=0.5 '+string(ifmax50,f=ff3)+string(ifmin50,f=ff3) $
	+string(amp50,f=ff3) & yl=yl+dyl*1.2
xyouts,xl,yl,/data,'relative to ansa: LON(min), I(min), AMP'  & yl=yl+dyl
endif

apu=abs(azitable-270.)
index=where(apu eq min(apu))
i270=index(0)


xarg=0.5*findgen(180*2)+180
yarg=spline(azitable,iperf*meanw,xarg)
yarg=smooth(yarg,8)
minpos=where(yarg eq min(yarg))
minval=yarg(minpos(0))/(iperf*meanw(i270))
minpos=xarg(minpos(0))-270.


if PLOT then $
xyouts,xl,yl,/data,'  ALB=1.0 '+string(minpos,f=ff)+string(minval,f=ff3) $
	+string(1-minval,f=ff3) & yl=yl+dyl

xarg=0.5*findgen(180*2)+180
yarg=spline(azitable,iperf*meanw50,xarg)
yarg=smooth(yarg,8)
minpos=where(yarg eq min(yarg))
minval=yarg(minpos(0))/(iperf*meanw50(i270))
minpos=xarg(minpos(0))-270.


yr=[0.8,1.4]
if(keyword_set(yrange0)) then yr=yrange0

if PLOT then begin
xyouts,xl,yl,/data,'  ALB=0.5 '+string(minpos,f=ff)+string(minval,f=ff3) $
	+string(1-minval,f=ff3) & yl=yl+dyl*2

xyouts,0.01,0.01,'plot produced by mc_asy_plot1.pro',charsize=0.5,/normal

plot,azitable-270,meanw50/meanw50(i270),psym=-6,$
	xtitle='Longitude relative to ansa',$
	ytitle='normalized intensity (assume alb=0.5)',$
	xr=[-60,60],yr=yr,xs=1,ys=1,pos=posi2,$
	/noe,symsize=0.5,title='dashed: alb=1'
oplot,azitable-270.,azitable*0.+1

oplot,azitable-270,meanw/meanw(i270),lines=2,col=2,psym=-6
endif

; now add Fourier fit to these two
theta=azitable-270.0
l=where(theta ge (-60.) and theta le 60.,nl)

if(nl ge 3) then begin

theta_min=round(theta[l[0]])
theta_max=round(theta[l[nl-1]])
nth=theta_max-theta_min+1
nbin=100
thetas=theta_min + findgen(nth*nbin+1)/nbin
nmid=(where(min(abs(thetas)) eq abs(thetas)))[0]
ncoeff=6

; albedo = 0.5 case
fourier_azscan,theta,iperf*meanw50,ncoeff,modelw50,coeffs
ym50=fourier_calc(thetas,coeffs)

; compute theta_min,width,theta_min_flux,flux_ansa,frac_depth1,frac_depth2
l=(where(ym50 eq min(ym50)))[0]
theta_min_val=thetas[l]
theta_min_flux=ym50[l]
;theta_max_flux=ym50[nmid + nmid-l] ; this does not work well
theta_max_flux=max(ym50[nmid:*])	; use max flux within 60 deg of ansa
flux_ansa=ym50[nmid]
l=max(where(ym50[0:l] gt flux_ansa),count)
width=-999.
if(count ge 1) then width=abs(thetas[l])
frac_depth1=(theta_max_flux - theta_min_flux)/theta_min_flux
frac_depth2=(flux_ansa - theta_min_flux)/flux_ansa



; do same for albedo=1.0 case
fourier_azscan,theta,iperf*meanw,ncoeff,modelw,coeffs
ym=fourier_calc(thetas,coeffs)
if PLOT then begin
oplot,thetas,ym50/ym50[nmid],col=5
oplot,thetas,ym/ym[nmid],col=3,lines=2

l100=(where(ym eq min(ym)))[0]
theta_min_val100=thetas[l100]

af='(f7.3)'
af2='(f7.1)'
st=string(max(ym50),af)+string(min(ym50),af)+string(theta_min_val,af2)
xyouts,-50,yr(0)+0.9*(yr(1)-yr(0)),'AZSCAN (0.5): '+st

st=string(max(ym),af)+string(min(ym),af)+string(theta_min_val100,af2)
xyouts,-50,yr(0)+0.8*(yr(1)-yr(0)),'AZSCAN (1.0): '+st

min50=theta_min_val
min100=theta_min_val100

print,'fourier_azscan:'
print,'within 60 degrees from ansa'
print,'ALB=1.0  ifmax,ifmin    ',max(ym),min(ym)
print,'ALB=0.5  ifmax,ifmin,min',max(ym50),min(ym50),theta_min_val

endif  ;nl theta interval
endif

if PLOT then begin
print,'here'
plot,azitable,iperf*meanw,psym=6,xtitle='Azimuth',$
ytitle='I/F',pos=posi3,/noera,symsize=0.5,title='total, sca=1,2,3,4',$
	yr=[0.001,1],ys=1,/ylog
oplot,azitable,iperf*meanm(*,0),col=1
oplot,azitable,iperf*meanm(*,1),col=2
oplot,azitable,iperf*meanm(*,2),col=3
oplot,azitable,iperf*meanm(*,3),col=4

apuli=meanm(*,0)*0.
for ite=0,9 do begin
apuli=apuli+meanm(*,ite)*iperf
endfor
oplot,azitable,apuli,col=2

ymin=min(tablew)*iperf
ymax=max(tablew)*iperf

plot,azitable,iperf*meanw,psym=-6,xtitle='Azimuth',ytitle='I/F',$
	pos=posi4,/noera,symsize=0.25,title='pos-files separately',$
	thick=2,yrange=[ymin,ymax]

for i=0,npos-1 do begin
vast=''
if(keyword_set(wait)) then read,vast
if(keyword_set(wait)) then print,'pos,col=',pos1+i,i+2
oplot,azitable,tablew(*,i)*iperf,col=i+2
endfor

oplot,azitable,iperf*meanw,psym=-6,symsize=0.25,thick=4
oplot,azitable,iperf*meanw,psym=-6,symsize=0.25,thick=1


endif
!p.charsize=0

end










