pro fourier_funct,info,params,ymodel,pder,$
	noderivative=noderivative,fitlist=fitlist
;
; Used with fourier_azscan.pro

npts		=info.npts 
theta_deg	=info.theta_deg
y		=info.y
weights		=info.weights

nparams=n_elements(params)
n_coeff=nparams/2+1

; extract fourier coefficient 

a=params[0:n_coeff-1]
if n_coeff gt 1 then b=params[n_coeff:*]

x=theta_deg*!dtor ; convert to radians

ymodel=fltarr(npts)
ymodel[*]=a[0]
for n=1,n_coeff-1 do begin
	ymodel=ymodel + a[n]*cos(n*x) + b[n-1]*sin(n*x)
endfor

if n_params(0) le 3 or keyword_set(NODERIVATIVE) then return

print,'ERROR! Unable to compute partial derivatives in fourier_funct!'
STOP
end
