function fourier_calc,theta_deg,params
;
; compute model values for a fourier series
; 
; Revisions:
;	16 November 1999 - rfrench

npts		=n_elements(theta_deg)

nparams=n_elements(params)
n_coeff=nparams/2+1

; extract fourier coefficient 

a=params[0:n_coeff-1]
if n_coeff gt 1 then b=params[n_coeff:*]

x=theta_deg*!dtor ; convert to radians

ymodel=fltarr(npts)
ymodel[*]=a[0]
for n=1,n_coeff-1 do begin
	ymodel=ymodel + a[n]*cos(n*x) + b[n-1]*sin(n*x)
endfor
return,ymodel
end
