; from Dick French
; fourier_azscan.pro Fri Oct  8 11:12:46 EDT 1999
; decompose azimuthal scan into a set of fourier coefficients.
;
; Revisions:
;	8 Oct 1999 - do Fourier analysis

pro fourier_azscan,theta_vals,yvals,n_coeff, ymodel,a_final

npts=n_elements(theta_vals)
weights=fltarr(npts)+1.0
n_params=2*n_coeff-1 ; 
a=fltarr(n_params)
fitlist=intarr(n_params)+1

finite_diffs=fltarr(n_params)+.001

tags=['npts','theta_deg','y','weights']
info= create_struct(tags,0L,dblarr(npts),dblarr(npts),dblarr(npts))
info.npts	=npts
info.theta_deg	=theta_vals
info.y		=yvals
info.weights	=weights

a_init=a
convcrit=1.d-6
noderivative=1        
ymodel = rgfcurvefit4(info,yvals,weights,a_init,sig_a,chisq,correl_matrix,$
                niter_used,converged,$
                FUNCTION_NAME='fourier_funct',FITLIST=fitlist, $
                PRINTEACH=printeach, CONVCRIT=convcrit, $
                NITER=niter,$
                FINITE_DIFFS=finite_diffs,$
                NODERIVATIVE=noderivative)
a_final=a_init
end

; test procedure
pro tfourier_azscan
;restore,'/ahab6/local/rsi/local/rpx/azscan.sav'
restore,'azscan.sav'
n_coeff=4 	; number of fourier coefficients
read,prompt='Enter number of fourier coefficients to use: ',n_coeff
fourier_azscan,theta_vals,yvals,n_coeff, ymodel,a_final
plot,theta_vals,yvals,ystyle=3
oplot,theta_vals, ymodel,line=1
end

;tfourier_azscan
;end
