restore,'V50_bright_star.save'

close,1
openw,1,'kirkkaat_tahdet.dat'
printf,1,'ATK Tahtitieteessa kurssin harjoitustyo:'
printf,1,'Kirkkaimpien tahtien koordinaatit ja naennainen magnitudi'
printf,1,'      RA (deg)     DEC (deg)     VMAG '

for i=0,n_elements(ra)-1 do begin
    printf,1,ra(i),dec(i),vmag(i),format='(2f14.6,4x,f6.3)'
endfor
close,1
save,file='kirkkaat_tahdet_motion.save',pmra,pmde,name


;--------------------------------------

psopen,'kirkkaat_tahdet_all.ps'
plot,ra,dec,psym=3,xtitle='REKTASKENSIO',ytitle='DEKLINAATIO',$
  xr=[360,0],yr=[-90,90],title='kirkkaat tahdet',xs=1,ys=1
psclose

year=2000.
j=1
glactc, ra/360.*24., dec, year, gl, gb, j

psopen,'kirkkaat_tahdet_all_gal.ps'
plot,gl,gb,psym=3,xtitle='GALAKTINEN LONGITUDI',ytitle='GALAKTINEN LEVEYS',$
  xr=[360,0],yr=[-90,90],title='kirkkaat tahdet',xs=1,ys=1
psclose





vast=''
brightstar_malli,malli='orion',/ch,size=1. & read,vast
brightstar_malli,malli='seulaset',/ch,size=1.& read,vast
brightstar_malli,malli='leijona',/ch,size=1.& read,vast
brightstar_malli,malli='otava',/ch,size=1.& read,vast
brightstar_malli,malli='kassiopeia',/ch,size=1.& read,vast
brightstar_malli,malli='ajomies',/ch,size=1.& read,vast
brightstar_malli,malli='lyyra',/ch,size=1.& read,vast
brightstar_malli,malli='kaksoset',/ch,size=1.& read,vast



end
