pro brightstar_malli,rat,dect,title,malli=malli,check=check,proper=proper,$
examples=examples,circle=circle,oplot=oplot,size0=size0

if((n_params() le 0 and not keyword_set(malli))$
   or keyword_set(examples)) then begin

    print,'brightstar_malli,[ra1,ra2],[dec1,dec2],title'
    print,"brightstar_malli,malli='orion'"
    print,"for i=0,100 do begin & brightstar_malli,malli='orion',proper=i*5000. & endfor"
    return
endif


;--------------------------------------------
;tiedoston lukeminen
;--------------------------------------------

  close,1
  openr,1,'kirkkaat_tahdet.dat'

;luetaan kolme merkki tietorivia
  line=''
  readf,1,line & readf,1,line & readf,1,line

;valmistaudutaan lukemaan korkeintaa 10000 rivia
  ra=fltarr(10000) & dec=ra & vmag=ra
  ind=-1
  while not eof(1)do begin
      readf,1,ra1,dec1,vmag1
      ind=ind+1
      ra(ind)=ra1 & dec(ind)=dec1 & vmag(ind)=vmag1
  endwhile
  
;siivotaan taulukot
  ra=ra(0:ind) & dec=dec(0:ind) & vmag=vmag(0:ind)
 
;---------------------------------------------

;omia testeja varten:
;tahdisto voidaan antaa keywordina

  if(keyword_set(malli)) then begin

      if(malli eq 'orion') then begin
          rat=[4.8, 6.5]*15.    ;MUUTETAAN TUNNIT ASTEIKSI
          dect=[-15,10]
          title='ORION'
      endif
      if(malli eq 'seulaset') then begin
          rat=[3.667, 3.91667]*15.    ;MUUTETAAN TUNNIT ASTEIKSI
          dect=[22.5,26]
          title='SEULASET'
      endif
      if(malli eq 'otava') then begin
          rat=[10, 14.25]*15.    ;MUUTETAAN TUNNIT ASTEIKSI
          dect=[40,75]
          title='OTAVA'
      endif
      if(malli eq 'hyadit') then begin
          rat=[3.667, 6]*15.    ;MUUTETAAN TUNNIT ASTEIKSI
          dect=[0,30]
          title='HYADIT'
      endif
      if(malli eq 'kassiopeia') then begin
          rat=[-0.333,2.33]*15.    ;MUUTETAAN TUNNIT ASTEIKSI
          dect=[50,70]
          title='Kassiopeia'
      endif
      if(malli eq 'ajomies') then begin
          rat=[4.5,6.5]*15. ;MUUTETAAN TUNNIT ASTEIKSI
          dect=[30,52]
          title='Ajomies'
      endif

      if(malli eq 'lyyra') then begin
          rat=[18,19.5]*15. ;MUUTETAAN TUNNIT ASTEIKSI
          dect=[28,45]
          title='Lyyra'
      endif

      if(malli eq 'kaksoset') then begin
          rat=[6.5,8]*15. ;MUUTETAAN TUNNIT ASTEIKSI
          dect=[20,40]
          title='Kaksoset'
      endif

      if(malli eq 'leijona') then begin
          rat=[9.5,12.25]*15. ;MUUTETAAN TUNNIT ASTEIKSI
          dect=[0,40]
          title='Leijona'
      endif
      




  endif


;------------------------------------------------
;rektaskensio ja deklinaatiovalit (asteina)
  ra1=rat(0)
  ra2=rat(1)
  dec1=dect(0)
  dec2=dect(1)

if(keyword_set(check)) then begin
;omia tarkistuksia
  print,title
;tulosta valittu rektaskensiovali tunneissa
  print,'RA1 (hms):',sixty(ra1/15.)
  print,'RA2 (hms):',sixty(ra2/15.)
;deklinaatiovali asteissa
  print,'dec1 (dms):',sixty(dec1)
  print,'dec2 (dms):',sixty(dec2)
;aspekti-suhde
  print,'y/x=',(dec2-dec1)/(cos(0.5*(dec1+dec2)/180.*!pi)*(ra2-ra1))
endif




;------------------------------------------------------------
;tahan IDL-save tiedostoon on tallennettu
;tahtien nimet (voi olla tyhja merkkimuuttuja)
;seka pmra ja pmde = ominaisliikkeet RA ja de suunnissa (kaarisekuntia/vuosi)
  
restore,'kirkkaat_tahdet_motion.save'



;varmuuden vuoksi, jos RA raja menee yli nollan

ra=[ra-360,ra]
dec=[dec,dec]
vmag=[vmag,vmag]
pmra=[pmra,pmra]
pmde=[pmde,pmde]
name=[name,name]


;lisataanko ominaisliikkeet ?
;Periaatteessa olisi otettava huomioon, ett RA ja DEC ovat 
;pallokoordinaatteja. Pienille siirroksille voidaan kuitenkin
;yksinkertaisesti lisata 
;            DEC =DEC+pmde(asteissa/vuosi)*aika(vuosissa)
;            RA  = RA+pmra(asteissa/vuosi)*aika(vuosissa)/cos(DEC)
;jossa jalkimmaisen kaavan viimeinen termi tulee siita etta
;leveyspiirit lyhenevat navoille mentaessa tekijalla cos(DEC)
;(eli pmra on suureen cos(DEC)*RA muutos)


if(keyword_set(proper)) then begin
    ra=ra+pmra/cos(dec/!radeg)/3600.*proper
    dec=dec+pmde/3600.*proper

    title=title+' ominaisliike '+string(proper)+' vuodelle'
endif





;-------------------------------------------------
;poimitaan tahdet jotka tayttavat ehdot
;vmag < 6, ra ja dec annetulla valilla)

  ind=where(vmag le 6.0 and $
            ra gt ra1 and ra le ra2 and $
            dec gt dec1 and dec lt dec2)


  ra=ra(ind)
  dec=dec(ind)
  vmag=vmag(ind)

;myos naille
  pmra=pmra(ind)
  pmde=pmde(ind)
  name=name(ind)


;asetetaan plotin rajat: huomaa RA jarjestys
  xr=[ra2,ra1]
  yr=[dec1,dec2]

if(not keyword_set(oplot)) then begin
  plot,ra,dec,psym=3,xr=xr,xs=1,yr=yr,ys=1,/nod,$
    xtitle='REKTASKENSIO (deg)',ytitle='DECLINAATI0 (deg)',tit=title,$
    position=[0.1,0.1,0.75,0.9]
endif

;symbolien koot magnitudivaleille
;-2 < -1
;-1 <  0
; 0 <  1
; 1 <  2
; 2 <  3
; 3 <  4
; 4 <  5
; 5 <  6


  sizetab=[1.2, 1.0, 0.9, 0.8, 0.6, 0.4, 0.2, 0.1]*3
if(keyword_set(size0)) then sizetab=sizetab*size0
  infotab=['   < -1',$
           '-1 <  0',$
           ' 0 <  1',$
           ' 1 <  2',$
           ' 2 <  3',$
           ' 3 <  4',$
           ' 4 <  5',$
           ' 5 <  6']


;selitysplotit: paikka datakoordinaateissa
;symboli
  xpos=xr(0)+1.1*(xr(1)-xr(0))
;teksti
  xpos2=xr(0)+1.15*(xr(1)-xr(0))
;molemmille
;aloituskohta
  ypos=yr(0)+0.9*(yr(1)-yr(0))
;muutos
  dypos=0.075*(yr(1)-yr(0))


  for i=0,7 do begin

;valikoi vali
      ind=where(vmag le i and vmag gt i-1, count)
      size=sizetab(i)
      !psym=2
      if(keyword_set(circle)) then begin
          boxsym,/g20,1
      endif

;plottaa selite: symboli ja teksti    
      plots,xpos,ypos-i*dypos,symsize=size
      xyouts,xpos2,ypos-i*dypos,infotab(i)

;plottaa tahdet jos on talla magnitudivalilla
    if(count ge 1) then begin
        oplot,ra(ind),dec(ind),symsize=size
    endif
endfor


defplot

plot_stamp,'malli'



end
