

file='kirkkaat_tahdet.dat'

n=file_lines(file)-3

ra=fltarr(n)
dec=fltarr(n)
mag=fltarr(n)

openr,1,file

junk=''
readf,1,junk
readf,1,junk
readf,1,junk


for i=0,n-1 do begin
   readf,1,temp1,temp2,temp3

   ra(i)=temp1
   dec(i)=temp2
   mag(i)=temp3

endfor

close,1

!p.charsize=1.
psdirect,'all_stars',1
plot,ra,dec,xtitle='Rektaskensio',ytitle='Deklinaatio',$
     xr=[360,0],yr=[-90,90],xs=1,ys=1,psym=6,symsize=0.1
psdirect,'all_stars',1,/stop
!p.charsize=1.


year=2000.
j=1

glactc,ra/360.*24., dec, year, gl, gb,j


!p.charsize=1.
psdirect,'all_stars_galac',1
plot,gl,gb,xtitle='Galaktinen longitudi',ytitle='Galactinen leveys',$
     xr=[360,0],yr=[-90,90],xs=1,ys=1,psym=6,symsize=0.1
psdirect,'all_stars_galac',1,/stop
!p.charsize=1.



;orion:
ymin=-15.
ymax=10.

xmin=4*15. + 48 * .25
xmax = 6 * 15. + 30 * .25


;leijona:
ymin=0.
ymax=40.
xmin=9*15. + 30 * .25
xmax = 12 * 15. + 15 * .25

;otava
;ymin=40.
;ymax=75.

;xmin=10*15.
;xmax = 14 * 15. + 15 * .25



ind=where(mag le 1.8)
kartta_a=plot(ra(ind),dec(ind),xrange=[xmax,xmin],yrange=[ymin,ymax],$
            symbol='circle',/sym_filled,sym_size=3.,$
            linestyle='none',name='v $\leq 1$',position=[0.1,0.1,0.75,0.9],$
             xtitle='Rektaskensio',ytitle='Deklinaatio',title='Orion')

ind=where(mag gt 1 and mag le 2)
kartta_b=plot(ra(ind),dec(ind),/overplot,$
            symbol='circle',/sym_filled,sym_size=1.8,$
            linestyle='none',name='1 < v $\leq$ 2')


ind=where(mag gt 2 and mag le 3)
kartta_c=plot(ra(ind),dec(ind),/overplot,$
            symbol='circle',/sym_filled,sym_size=1.3,$
            linestyle='none',name='2 < v $\leq$ 3')


ind=where(mag gt 3 and mag le 4)
kartta_d=plot(ra(ind),dec(ind),/overplot,$
            symbol='circle',/sym_filled,sym_size=1.,$
            linestyle='none',name='3 < v $\leq$ 4')

ind=where(mag gt 4 and mag le 5)
kartta_E=plot(ra(ind),dec(ind),/overplot,$
            symbol='circle',/sym_filled,sym_size=0.6,$
            linestyle='none',name='4 < v $\leq$ 5')

ind=where(mag gt 5 and mag le 6)
kartta_f=plot(ra(ind),dec(ind),/overplot,$
            symbol='circle',/sym_filled,sym_size=0.3,$
            linestyle='none',name='5 < v $\leq$ 6')


leg=legend(target=[kartta_a,kartta_b,kartta_c,kartta_d,kartta_e,kartta_f],$
          horizontal_spacing=0.1,vertical_spacing=0.075,sample_width=0.,position=[0.96,0.9],$
          font_size=10.)

kartta_a.save,'orion.pdf',resolution=1000,/landscape



ind=where(ra ge xmin and ra le xmax and dec ge ymin and dec le ymax)
ra=ra(ind)
dec=dec(ind)
mag=mag(ind)



ra=ra-mean(ra)
;dec=dec-mean(dec)

;x=2.*sqrt(2.)/!dpi * (ra-mean([xmin,xmax]))*cos(dec*(!dpi/180.))
;y=sqrt(2.)*sin(dec*(!dpi/180.))

aitoff,ra,dec,x,y


ind=where(mag le 1.8)
kartta_a=plot(x(ind),y(ind),$
            symbol='circle',/sym_filled,sym_size=3.,$
            linestyle='none',name='v $\leq 1$',position=[0.1,0.1,0.75,0.9],$
             xtitle='Rektaskensio',ytitle='Deklinaatio',title='Orion')

ind=where(mag gt 1 and mag le 2)
kartta_b=plot(x(ind),y(ind),/overplot,$
            symbol='circle',/sym_filled,sym_size=1.8,$
            linestyle='none',name='1 < v $\leq$ 2')


ind=where(mag gt 2 and mag le 3)
kartta_c=plot(x(ind),y(ind),/overplot,$
            symbol='circle',/sym_filled,sym_size=1.3,$
            linestyle='none',name='2 < v $\leq$ 3')


ind=where(mag gt 3 and mag le 4)
kartta_d=plot(x(ind),y(ind),/overplot,$
            symbol='circle',/sym_filled,sym_size=1.,$
            linestyle='none',name='3 < v $\leq$ 4')

ind=where(mag gt 4 and mag le 5)
kartta_E=plot(x(ind),y(ind),/overplot,$
            symbol='circle',/sym_filled,sym_size=0.6,$
            linestyle='none',name='4 < v $\leq$ 5')

ind=where(mag gt 5 and mag le 6)
kartta_f=plot(x(ind),y(ind),/overplot,$
            symbol='circle',/sym_filled,sym_size=0.3,$
            linestyle='none',name='5 < v $\leq$ 6')


leg=legend(target=[kartta_a,kartta_b,kartta_c,kartta_d,kartta_e,kartta_f],$
          horizontal_spacing=0.1,vertical_spacing=0.075,sample_width=0.,position=[0.96,0.9],$
          font_size=10.)


end
